--[[
loottables.en.lua
This file assigns a title to every loot table.  The primary use of this table
is in the search function, as when iterating through the loot tables there is no
inherant title to the loot table, given the origins of the mod as an Atlas plugin.
]]

--Invoke libraries
local BabbleTrade=AceLibrary("Babble-Tradeskill-2.2");
local BabbleFaction = AceLibrary("Babble-Faction-2.2");

--Table of loot titles
AtlasLoot_TableNames = {};

-----------------
--- Instances ---
-----------------

  --Keys
    AtlasLoot_TableNames["OldKeys"] = { "Keys", "AtlasLootItems" };
    AtlasLoot_TableNames["BCKeys"] = { "Keys", "AtlasLootExpansionItems" };
  --Auch: Auchenai Crypts
    AtlasLoot_TableNames["AuchCryptsShirrak"] = { "Shirrak the Dead Watcher", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchCryptsShirrakHEROIC"] = { "Shirrak the Dead Watcher (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchCryptsExarch"] = { "Exarch Maladaar", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchCryptsExarchHEROIC"] = { "Exarch Maladaar (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchCryptsAvatar"] = { "Avatar of the Martyred", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchCryptsTrash"] = { "Trash Mobs (Auchenai Crypts)", "AtlasLootExpansionItems" };
  --Auch: Mana-Tombs
    AtlasLoot_TableNames["AuchManaPandemonius"] = { "Pandemonius", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaPandemoniusHEROIC"] = { "Pandemonius (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaTavarok"] = { "Tavarok", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaTavarokHEROIC"] = { "Tavarok (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaNexusPrince"] = { "Nexus-Prince Shaffar", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaNexusPrinceHEROIC"] = { "Nexus-Prince Shaffar (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaYor"] = { "Yor", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchManaTrash"] = { "Trash Mobs (Mana-Tombs)", "AtlasLootExpansionItems" };
  --Auch: Sethekk Halls
    AtlasLoot_TableNames["AuchSethekkDarkweaver"] = { "Darkweaver Syth", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchSethekkDarkweaverHEROIC"] = { "Darkweaver Syth (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchSethekkTheSagaofTerokk"] = { "The Saga of Terokk", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchSethekkRavenGod"] = { "Raven God Anzu", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchSethekkTalonKing"] = { "Talon King Ikiss", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchSethekkTalonKingHEROIC"] = { "Talon King Ikiss (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchSethekkTrash"] = { "Trash Mobs (Sethekk Halls)", "AtlasLootExpansionItems" };
  --Auch: Shadow Labyrinth
    AtlasLoot_TableNames["AuchShadowHellmaw"] = { "Ambassador Hellmaw", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowHellmawHEROIC"] = { "Ambassador Hellmaw (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowBlackheart"] = { "Blackheart the Inciter", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowBlackheartHEROIC"] = { "Blackheart the Inciter (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowGrandmaster"] = { "Grandmaster Vorpil", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowGrandmasterHEROIC"] = { "Grandmaster Vorpil (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowMurmur"] = { "Murmur", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowMurmurHEROIC"] = { "Murmur (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowFirstFragmentGuardian"] = { "First Fragment Guardian", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["AuchShadowTrash"] = { "Trash Mobs (Shadow Labyrinth)", "AtlasLootExpansionItems" };
  --Blackfathom Deeps
    AtlasLoot_TableNames["BFDGhamoora"] = { "Ghamoo-ra", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDLadySarevess"] = { "Lady Sarevess", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDGelihast"] = { "Gelihast", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDBaronAquanis"] = { "Baron Aquanis", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDTwilightLordKelris"] = { "Twilight Lord Kelris", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDOldSerrakis"] = { "Old Serra'kis", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDAkumai"] = { "Aku'mai", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDQuestItems"] = { "Quest Items (BFD)", "AtlasLootItems" };
    AtlasLoot_TableNames["BFDTrash"] = { "Trash Mobs (BFD)", "AtlasLootItems" };
  --Blackrock Mountain
    AtlasLoot_TableNames["BRMScarshieldQuartermaster"] = { "Scarshield Quartermaster", "AtlasLootItems" };
  --Blackrock Depths
    AtlasLoot_TableNames["BRDPyron"] = { "Overmaster Pyron", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDLordRoccor"] = { "Lord Roccor", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDHighInterrogatorGerstahn"] = { "High Interrogator Gerstahn", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDArena"] = { "Ring of Law", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDTheldren"] = { "Theldren", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDHoundmaster"] = { "Houndmaster Grebmar", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDForgewright"] = { "Monument of Franclorn Forgewright", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDPyromantLoregrain"] = { "Pyromancer Loregrain", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDTheVault"] = { "The Vault", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDWarderStilgiss"] = { "Warder Stilgiss", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDVerek"] = { "Verek", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDFineousDarkvire"] = { "Fineous Darkvire", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDLordIncendius"] = { "Lord Incendius", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDBaelGar"] = { "Bael'Gar", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDGeneralAngerforge"] = { "General Angerforge", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDGolemLordArgelmach"] = { "Golem Lord Argelmach", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDGuzzler"] = { "The Grim Guzzler", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDFlamelash"] = { "Ambassador Flamelash", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDPanzor"] = { "Panzor the Invincible (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDTomb"] = { "Summoner's Tomb", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDLyceum"] = { "Shadowforge Flame Keeper", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDMagmus"] = { "Magmus", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDPrincess"] = { "Princess Moira Bronzebeard", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDImperatorDagranThaurissan"] = { "Emperor Dagran Thaurissan", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDBSPlans"] = { "Blacksmith Plans (BRD)", "AtlasLootItems" };
    AtlasLoot_TableNames["BRDTrash"] = { "Trash Mobs (BRD)", "AtlasLootItems" };
  --Lower Blackrock Spire
    AtlasLoot_TableNames["LBRSQuestItems"] = { "Lower Blackrock Spire Quest Items", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSSpirestoneButcher"] = { "Spirestone Butcher (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSOmokk"] = { "Highlord Omokk", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSSpirestoneLord"] = { "Spirestone Battle Lord (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSLordMagus"] = { "Spirestone Lord Magus (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSVosh"] = { "Shadow Hunter Vosh'gajin", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSVoone"] = { "War Master Voone", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSGrayhoof"] = { "Mor Grayhoof (Summon)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSGrimaxe"] = { "Bannok Grimaxe (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSSmolderweb"] = { "Mother Smoulderweb", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSCrystalFang"] = { "Crystal Fang", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSDoomhowl"] = { "Urok Doomhowl (Summon)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSZigris"] = { "Quartermaster Zigris", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSHalycon"] = { "Halycon", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSSlavener"] = { "Gizrul the Slavener", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSBashguud"] = { "Ghok Bashguud (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSWyrmthalak"] = { "Overlord Wyrmthalak", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSFelguard"] = { "Burning Felguard (Rare, Random)", "AtlasLootItems" };
    AtlasLoot_TableNames["LBRSTrash"] = { "Trash Mobs (LBRS)", "AtlasLootItems" };
  --Upper Blackrock Spire
    AtlasLoot_TableNames["UBRSEmberseer"] = { "Pyroguard Emberseer", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSSolakar"] = { "Solakar Flamewreath", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSFLAME"] = { "Father Flame", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSRunewatcher"] = { "Jed Runewatcher", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSAnvilcrack"] = { "Goraluk Anvilcrack", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSRend"] = { "Warchief Rend Blackhand", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSGyth"] = { "Gyth", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSBeast"] = { "The Beast", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSValthalak"] = { "Lord Valthalak (Summon)", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSDrakkisath"] = { "General Drakkisath", "AtlasLootItems" };
    AtlasLoot_TableNames["UBRSTrash"] = { "Trash Mobs (UBRS)", "AtlasLootItems" };
  --The Black Temple
    AtlasLoot_TableNames["BTNajentus"] = { "High Warlord Naj'entus", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTSupremus"] = { "Supremus", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTGorefiend"] = { "Teron Gorefiend", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTBloodboil"] = { "Gurtogg Bloodboil", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTAkama"] = { "Shade of Akama", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTEssencofSouls"] = { "Essence of Souls", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTShahraz"] = { "Mother Shahraz", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTCouncil"] = { "Illidari Council", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTIllidanStormrage"] = { "Illidan Stormrage", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["BTTrash"] = { "Trash Mobs (Black Temple)", "AtlasLootExpansionItems" };
  --Blackwing Lair
    AtlasLoot_TableNames["BWLRazorgore"] = { "Razorgore the Untamed", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLVaelastrasz"] = { "Vaelastrasz the Corrupt", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLLashlayer"] = { "Broodlord Lashlayer", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLFiremaw"] = { "Firemaw", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLEbonroc"] = { "Ebonroc", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLFlamegor"] = { "Flamegor", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLChromaggus"] = { "Chromaggus", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLNefarian"] = { "Nefarian", "AtlasLootItems" };
    AtlasLoot_TableNames["BWLTrashMobs"] = { "Trash Mobs (BWL)", "AtlasLootItems" };
  --CFR: Serpentshrine Cavern
    AtlasLoot_TableNames["CFRSerpentHydross"] = { "Hydross the Unstable", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSerpentKarathress"] = { "Fathom-Lord Karathress", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSerpentMorogrim"] = { "Morogrim Tidewalker", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSerpentLeotheras"] = { "Leotheras the Blind", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSerpentLurker"] = { "The Lurker Below", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSerpentVashj"] = { "Lady Vashj", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSerpentTrash"] = { "Trash Mobs (Serpentshrine Cavern)", "AtlasLootExpansionItems" };
  --CFR: Slave Pens
    AtlasLoot_TableNames["CFRSlaveMennu"] = { "Mennu the Betrayer", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSlaveMennuHEROIC"] = { "Mennu the Betrayer (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSlaveRokmar"] = { "Rokmar the Crackler", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSlaveRokmarHEROIC"] = { "Rokmar the Crackler (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSlaveQuagmirran"] = { "Quagmirran", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSlaveQuagmirranHEROIC"] = { "Quagmirran (Heroic)", "AtlasLootExpansionItems" };
  --CFR: The Steamvault
    AtlasLoot_TableNames["CFRSteamThespia"] = { "Hydromancer Thespia", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamThespiaHEROIC"] = { "Hydromancer Thespia (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamSecondFragmentGuardian"] = { "Second Fragment Guardian", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamSteamrigger"] = { "Mekgineer Steamrigger", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamSteamriggerHEROIC"] = { "Mekgineer Steamrigger (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamWarlord"] = { "Warlord Kalithresh", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamWarlordHEROIC"] = { "Warlord Kalithresh (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRSteamTrash"] = { "Trash Mobs (Steamvault)", "AtlasLootExpansionItems" };
  --CFR: The Underbog
    AtlasLoot_TableNames["CFRUnderHungarfen"] = { "Hungarfen", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderHungarfenHEROIC"] = { "Hungarfen (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderGhazan"] = { "Ghaz'an", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderGhazanHEROIC"] = { "Ghaz'an (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderSwamplord"] = { "Swamplord Musel'ek", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderSwamplordHEROIC"] = { "Swamplord Musel'ek (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderStalker"] = { "The Black Stalker", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CFRUnderStalkerHEROIC"] = { "The Black Stalker (Heroic)", "AtlasLootExpansionItems" };
  --CoT: Old Hillsbrad Foothills
    AtlasLoot_TableNames["CoTHillsbradDrake"] = { "Lieutenant Drake", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTHillsbradDrakeHEROIC"] = { "Lieutenant Drake (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTHillsbradSkarloc"] = { "Captain Skarloc", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTHillsbradSkarlocHEROIC"] = { "Captain Skarloc (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTHillsbradHunter"] = { "Epoch Hunter", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTHillsbradHunterHEROIC"] = { "Epoch Hunter (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTHillsbradTrash"] = { "Trash Mobs (CoT: Hillsbrad)", "AtlasLootExpansionItems" };
  --CoT: Black Morass
    AtlasLoot_TableNames["CoTMorassDeja"] = { "Chrono Lord Deja", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTMorassDejaHEROIC"] = { "Chrono Lord Deja (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTMorassTemporus"] = { "Temporus", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTMorassTemporusHEROIC"] = { "Temporus (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTMorassAeonus"] = { "Aeonus", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTMorassAeonusHEROIC"] = { "Aeonus (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["CoTMorassTrash"] = { "Trash Mobs (CoT: Black Morass)", "AtlasLootExpansionItems" };
  --CoT: Hyjal Summit
    AtlasLoot_TableNames["MountHyjalWinterchill"] = { "Rage Winterchill", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["MountHyjalAnetheron"] = { "Anetheron", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["MountHyjalKazrogal"] = { "Kaz'rogal", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["MountHyjalAzgalor"] = { "Azgalor", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["MountHyjalArchimonde"] = { "Archimonde", "AtlasLootExpansionItems" };
  --The Deadmines
    AtlasLoot_TableNames["VCMarisaduPaige"] = { "Marisa du'Paige", "AtlasLootItems" };
    AtlasLoot_TableNames["VCBrainwashedNoble"] = { "Brainwashed Noble", "AtlasLootItems" };
    AtlasLoot_TableNames["VCForemanThistlenettle"] = { "Foreman Thistlenettle", "AtlasLootItems" };
    AtlasLoot_TableNames["VCRhahkZor"] = { "Rhahk'Zor", "AtlasLootItems" };
    AtlasLoot_TableNames["VCMinerJohnson"] = { "Miner Johnson (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["VCSneed"] = { "Sneed", "AtlasLootItems" };
    AtlasLoot_TableNames["VCSneedsShredder"] = { "Sneed's Shredder", "AtlasLootItems" };
    AtlasLoot_TableNames["VCGilnid"] = { "Gilnid", "AtlasLootItems" };
    AtlasLoot_TableNames["VCCaptainGreenskin"] = { "Captain Greenskin", "AtlasLootItems" };
    AtlasLoot_TableNames["VCVanCleef"] = { "Edwin VanCleef", "AtlasLootItems" };
    AtlasLoot_TableNames["VCMrSmite"] = { "Mr. Smite", "AtlasLootItems" };
    AtlasLoot_TableNames["VCCookie"] = { "Cookie", "AtlasLootItems" };
    AtlasLoot_TableNames["VCDefiasGunpowder"] = { "Defias Gunpowder", "AtlasLootItems" };
  --Dire Maul East
    AtlasLoot_TableNames["DMEPusillin"] = { "Pusillin", "AtlasLootItems" };
    AtlasLoot_TableNames["DMEZevrimThornhoof"] = { "Zevrim Thornhoof", "AtlasLootItems" };
    AtlasLoot_TableNames["DMEHydro"] = { "Hydrospawn", "AtlasLootItems" };
    AtlasLoot_TableNames["DMELethtendris"] = { "Lethtendris", "AtlasLootItems" };
    AtlasLoot_TableNames["DMEPimgib"] = { "Pimgib", "AtlasLootItems" };
    AtlasLoot_TableNames["DMEAlzzin"] = { "Alzzin the Wildshaper", "AtlasLootItems" };
    AtlasLoot_TableNames["DMEIsalien"] = { "Isalien", "AtlasLootItems" };
    AtlasLoot_TableNames["DMETrash"] = { "Trash Mobs (DM - East)", "AtlasLootItems" };
    AtlasLoot_TableNames["DMBooks"] = { "Dire Maul Books", "AtlasLootItems" };
  --Dire Maul North
    AtlasLoot_TableNames["DMNGuardMoldar"] = { "Guard Mol'dar", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNStomperKreeg"] = { "Stomper Kreeg", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNGuardFengus"] = { "Guard Fengus", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNThimblejack"] = { "Knot Thimblejack", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNGuardSlipkik"] = { "Guard Slip'kik", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNCaptainKromcrush"] = { "Captain Kromcrush", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNChoRush"] = { "Cho'Rush the Observer", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNKingGordok"] = { "King Gordok", "AtlasLootItems" };
    AtlasLoot_TableNames["DMNTRIBUTERUN"] = { "DM North Tribute Chest", "AtlasLootItems" };
  --Dire Maul West
    AtlasLoot_TableNames["DMWTendrisWarpwood"] = { "Tendris Warpwood", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWIllyannaRavenoak"] = { "Illyanna Ravenoak", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWMagisterKalendris"] = { "Magister Kalendris", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWTsuzee"] = { "Tsu'Zee", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWImmolthar"] = { "Immol'thar", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWHelnurath"] = { "Lord Hel'nurath", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWPrinceTortheldrin"] = { "Prince Tortheldrin", "AtlasLootItems" };
    AtlasLoot_TableNames["DMWTrash"] = { "Trash Mobs (DM - West)", "AtlasLootItems" };
  --Gnomeregan
    AtlasLoot_TableNames["GnNamdoBizzfizzle"] = { "Namdo Bizzfizzle", "AtlasLootItems" };
    AtlasLoot_TableNames["GnTechbot"] = { "Techbot", "AtlasLootItems" };
    AtlasLoot_TableNames["GnGrubbis"] = { "Grubbis", "AtlasLootItems" };
    AtlasLoot_TableNames["GnViscousFallout"] = { "Viscous Fallout", "AtlasLootItems" };
    AtlasLoot_TableNames["GnElectrocutioner6000"] = { "Electrocutioner 6000", "AtlasLootItems" };
    AtlasLoot_TableNames["GnCrowdPummeler960"] = { "Crowd Pummeler 9-60", "AtlasLootItems" };
    AtlasLoot_TableNames["GnDIAmbassador"] = { "Dark Iron Ambassador (Rare)", "AtlasLootItems" };
    AtlasLoot_TableNames["GnMekgineerThermaplugg"] = { "Mekgineer Thermaplugg", "AtlasLootItems" };
    AtlasLoot_TableNames["GnTrash"] = { "Trash Mobs (Gnomeregan)", "AtlasLootItems" };
  --Gruul's Lair
    AtlasLoot_TableNames["GruulsLairHighKingMaulgar"] = { "High King Maulgar", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["GruulGruul"] = { "Gruul the Dragonkiller", "AtlasLootExpansionItems" };
  --HC: Blood Furnace
    AtlasLoot_TableNames["HCFurnaceMaker"] = { "The Maker", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCFurnaceMakerHEROIC"] = { "The Maker (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCFurnaceBroggok"] = { "Broggok", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCFurnaceBroggokHEROIC"] = { "Broggok (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCFurnaceBreaker"] = { "Keli'dan the Breaker", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCFurnaceBreakerHEROIC"] = { "Keli'dan the Breaker (Heroic)", "AtlasLootExpansionItems" };
  --HC: Magtheridon's Lair
    AtlasLoot_TableNames["HCMagtheridon"] = { "Magtheridon", "AtlasLootExpansionItems" };
  --HC: Ramparts
    AtlasLoot_TableNames["HCRampWatchkeeper"] = { "Watchkeeper Gargolmar", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampWatchkeeperHEROIC"] = { "Watchkeeper Gargolmar (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampOmor"] = { "Omor the Unscarred", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampOmorHEROIC"] = { "Omor the Unscarred (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampVazruden"] = { "Vazruden", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampNazan"] = { "Nazan", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampFelIronChest"] = { "Reinforced Fel Iron Chest", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCRampFelIronChestHEROIC"] = { "Reinforced Fel Iron Chest (Heroic)", "AtlasLootExpansionItems" };
  --HC: Shattered Halls
    AtlasLoot_TableNames["HCHallsNethekurse"] = { "Grand Warlock Nethekurse", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsNethekurseHEROIC"] = { "Grand Warlock Nethekurse (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsPorung"] = { "Blood Guard Porung (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsOmrogg"] = { "Warbringer O'mrogg", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsOmroggHEROIC"] = { "Warbringer O'mrogg (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsKargath"] = { "Warchief Kargath Bladefist", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsKargathHEROIC"] = { "Warchief Kargath Bladefist (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["HCHallsTrash"] = { "Trash Mobs (HC: Shattered Halls)", "AtlasLootExpansionItems" };
  --Karazhan
    AtlasLoot_TableNames["KaraAttumen"] = { "Attumen the Huntsman", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraNamed"] = { "Servant's Quarter Animal Bosses", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraMoroes"] = { "Moroes", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraMaiden"] = { "Maiden of Virtue", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraOperaEvent"] = { "Opera Event", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraCurator"] = { "The Curator", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraIllhoof"] = { "Terestian Illhoof", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraAran"] = { "Shade of Aran", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraNetherspite"] = { "Netherspite", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraNightbane"] = { "Nightbane", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraChess"] = { "Chess Event", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraPrince"] = { "Prince Malchezaar", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["KaraTrash"] = { "Trash Mobs (Karazhan)", "AtlasLootExpansionItems" };
  --Maraudon
    AtlasLoot_TableNames["MaraNamelesProphet"] = { "The Nameles Prophet", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraKhanKolk"] = { "Kolk (The First Khan)", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraKhanGelk"] = { "Gelk (The Second Khan)", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraKhanMagra"] = { "Magra (The Third Khan)", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraKhanVeng"] = { "Veng (The Fifth Khan)", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraNoxxion"] = { "Noxxion", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraRazorlash"] = { "Razorlash", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraKhanMaraudos"] = { "Maraudos (The Forth Khan)", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraLordVyletongue"] = { "Lord Vyletongue", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraMeshlok"] = { "Meshlok the Harvester", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraCelebras"] = { "Celebras the Cursed", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraLandslide"] = { "Landslide", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraTinkererGizlock"] = { "Tinkerer Gizlock", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraRotgrip"] = { "Rotgrip", "AtlasLootItems" };
    AtlasLoot_TableNames["MaraPrincessTheradras"] = { "Princess Theradras", "AtlasLootItems" };
  --Molten Core
    AtlasLoot_TableNames["MCLucifron"] = { "Lucifron", "AtlasLootItems" };
    AtlasLoot_TableNames["MCMagmadar"] = { "Magmadar", "AtlasLootItems" };
    AtlasLoot_TableNames["MCGehennas"] = { "Gehennas", "AtlasLootItems" };
    AtlasLoot_TableNames["MCGarr"] = { "Garr", "AtlasLootItems" };
    AtlasLoot_TableNames["MCShazzrah"] = { "Shazzrah", "AtlasLootItems" };
    AtlasLoot_TableNames["MCGeddon"] = { "Baron Geddon", "AtlasLootItems" };
    AtlasLoot_TableNames["MCGolemagg"] = { "Golemagg the Incinerator", "AtlasLootItems" };
    AtlasLoot_TableNames["MCSulfuron"] = { "Sulfuron Harbinger", "AtlasLootItems" };
    AtlasLoot_TableNames["MCMajordomo"] = { "Majordomo Executus", "AtlasLootItems" };
    AtlasLoot_TableNames["MCRagnaros"] = { "Ragnaros", "AtlasLootItems" };
    AtlasLoot_TableNames["MCRANDOMBOSSDROPPS"] = { "Random Boss Drops", "AtlasLootItems" };
    AtlasLoot_TableNames["MCTrashMobs"] = { "Trash Mobs", "AtlasLootItems" };
  --Naxxramas
    AtlasLoot_TableNames["NAXPatchwerk"] = { "Patchwerk", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXGrobbulus"] = { "Grobbulus", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXGluth"] = { "Gluth", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXThaddius"] = { "Thaddius", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXAnubRekhan"] = { "Anub'Rekhan", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXGrandWidowFaerlina"] = { "Grand Widow Faerlina", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXMaexxna"] = { "Maexxna", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXInstructorRazuvious"] = { "Instructor Razuvious", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXGothikderHarvester"] = { "Gothik the Harvester", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXTheFourHorsemen"] = { "The Four Horsemen", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXNothderPlaguebringer"] = { "Noth the Plaguebringer", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXHeiganderUnclean"] = { "Heigan the Unclean", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXLoatheb"] = { "Loatheb", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXSapphiron"] = { "Sapphiron", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXKelThuzard"] = { "Kel'Thuzad", "AtlasLootItems" };
    AtlasLoot_TableNames["NAXTrash"] = { "Trash Mobs (Naxx)", "AtlasLootItems" };
  --Onyxia's Lair
    AtlasLoot_TableNames["Onyxia"] = { "Onyxia", "AtlasLootItems" };
  --Ragefire Chasm
    AtlasLoot_TableNames["RFCTaragaman"] = { "Taragaman the Hungerer", "AtlasLootItems" };
    AtlasLoot_TableNames["RFCJergosh"] = { "Jergosh the Invoker", "AtlasLootItems" };
  --Razorfen Downs
    AtlasLoot_TableNames["RFDTutenkash"] = { "Tuten'kash", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDHenryStern"] = { "Henry Stern", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDMordreshFireEye"] = { "Mordresh Fire Eye", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDGlutton"] = { "Glutton", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDRagglesnout"] = { "Ragglesnout", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDAmnennar"] = { "Amnennar the Coldbringer", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDPlaguemaw"] = { "Plaguemaw the Rotting", "AtlasLootItems" };
    AtlasLoot_TableNames["RFDTrash"] = { "Trash Mobs (RFD)", "AtlasLootItems" };
  --Razorfen Kraul
    AtlasLoot_TableNames["RFKThorncurse"] = { "Aggem Thorncurse", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKDeathSpeakerJargba"] = { "Death Speaker Jargba", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKOverlordRamtusk"] = { "Overlord Ramtusk", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKAgathelos"] = { "Agathelos the Raging", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKBlindHunter"] = { "Blind Hunter", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKCharlgaRazorflank"] = { "Charlga Razorflank", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKEarthcallerHalmgar"] = { "Earthcaller Halmgar", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKRoogug"] = { "Roogug", "AtlasLootItems" };
    AtlasLoot_TableNames["RFKTrash"] = { "Trash Mobs (RFK)", "AtlasLootItems" };
  --The Ruins of Ahn'Qiraj
    AtlasLoot_TableNames["AQ20Kurinnaxx"] = { "Kurinnaxx", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Andorov"] = { "Lieutenant General Andorov", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20CAPTIAN"] = { "Rajaxx's Captains", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Rajaxx"] = { "General Rajaxx", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Moam"] = { "Moam", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Buru"] = { "Buru the Gorger", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Ayamiss"] = { "Ayamiss the Hunter", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Ossirian"] = { "Ossirian the Unscarred", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20Trash"] = { "Trash Mobs (AQ20)", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ20ClassBooks"] = { "AQ Class Books", "AtlasLootItems" };
    AtlasLoot_TableNames["AQEnchants"] = { "AQ Enchants", "AtlasLootItems" };
  --Scarlet Monestery - Armory
    AtlasLoot_TableNames["SMHerod"] = { "Herod", "AtlasLootItems" };
    AtlasLoot_TableNames["SMTrash"] = { "Trash Mobs (SM)", "AtlasLootItems" };
  --Scarlet Monestery - Cathedral
    AtlasLoot_TableNames["SMFairbanks"] = { "High Inquisitor Fairbanks", "AtlasLootItems" };
    AtlasLoot_TableNames["SMMograine"] = { "Scarlet Commander Mograine", "AtlasLootItems" };
    AtlasLoot_TableNames["SMWhitemane"] = { "High Inquisitor Whitemane", "AtlasLootItems" };
  --Scarlet Monestery - Graveyard
    AtlasLoot_TableNames["SMVishas"] = { "Interrogator Vishas", "AtlasLootItems" };
    AtlasLoot_TableNames["SMIronspine"] = { "Ironspine", "AtlasLootItems" };
    AtlasLoot_TableNames["SMAzshir"] = { "Azshir the Sleepless", "AtlasLootItems" };
    AtlasLoot_TableNames["SMFallenChampion"] = { "Fallen Champion", "AtlasLootItems" };
    AtlasLoot_TableNames["SMBloodmageThalnos"] = { "Bloodmage Thalnos", "AtlasLootItems" };
  --Scarlet Monestery - Library
    AtlasLoot_TableNames["SMHoundmasterLoksey"] = { "Houndmaster Loksey", "AtlasLootItems" };
    AtlasLoot_TableNames["SMDoan"] = { "Arcanist Doan", "AtlasLootItems" };
  --Scholomance
    AtlasLoot_TableNames["SCHOLOBloodStewardofKirtonos"] = { "Blood Steward of Kirtonos", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOKirtonostheHerald"] = { "Kirtonos the Herald", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOJandiceBarov"] = { "Jandice Barov", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLORattlegore"] = { "Rattlegore", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLODeathKnight"] = { "Death Knight Darkreaver", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOMarduk"] = { "Marduk Blackpool", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOVectus"] = { "Vectus", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLORasFrostwhisper"] = { "Ras Frostwhisper", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOKormok"] = { "Kormok", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOInstructorMalicia"] = { "Instructor Malicia", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLODoctorTheolenKrastinov"] = { "Doctor Theolen Krastinov", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOLorekeeperPolkelt"] = { "Lorekeeper Polkelt", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOTheRavenian"] = { "The Ravenian", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOLordAlexeiBarov"] = { "Lord Alexei Barov", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOLadyIlluciaBarov"] = { "Lady Illucia Barov", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLODarkmasterGandling"] = { "Darkmaster Gandling", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOQuestItems"] = { "Quest Items (SCHOLO)", "AtlasLootItems" };
    AtlasLoot_TableNames["SCHOLOTrash"] = { "Trash Mobs (SCHOLO)", "AtlasLootItems" };
  --Shadowfang Keep
    AtlasLoot_TableNames["BSFRazorclawtheButcher"] = { "Razorclaw the Butcher", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFSilverlaine"] = { "Baron Silverlaine", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFSpringvale"] = { "Commander Springvale", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFOdotheBlindwatcher"] = { "Odo the Blindwatcher", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFFenrustheDevourer"] = { "Fenrus the Devourer", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFWolfMasterNandos"] = { "Wolf Master Nandos", "AtlasLootItems" };
  
    AtlasLoot_TableNames["BSFArchmageArugal"] = { "Archmage Arugal", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFDeathswornCaptain"] = { "Deathsworn Captain", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFFelSteed"] = { "Felsteed", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFRethilgore"] = { "Rethilgore", "AtlasLootItems" };
    AtlasLoot_TableNames["BSFTrash"] = { "Trash Mobs (SFK)", "AtlasLootItems" };
  --The Stockade
    AtlasLoot_TableNames["SWStTargor"] = { "Targorr the Dread", "AtlasLootItems" };
    AtlasLoot_TableNames["SWStKamDeepfury"] = { "Kam Deepfury", "AtlasLootItems" };
    AtlasLoot_TableNames["SWStBazilThredd"] = { "Bazil Thredd", "AtlasLootItems" };
    AtlasLoot_TableNames["SWStDextrenWard"] = { "Dextren Ward", "AtlasLootItems" };
    AtlasLoot_TableNames["SWStBruegalIronknuckle"] = { "Bruegal Ironknuckle", "AtlasLootItems" };
  --Stratholme
    AtlasLoot_TableNames["STRATSkull"] = { "Skul", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATStratholmeCourier"] = { "Mailbox Keys", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATFrasSiabi"] = { "Fras Siabi", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATAtiesh"] = { "Atiesh <Hand of Sargeras>", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATHearthsingerForresten"] = { "Hearthsinger Forresten", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATTheUnforgiven"] = { "The Unforgiven", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATTimmytheCruel"] = { "Timmy the Cruel", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATMalorsStrongbox"] = { "Malor's Strongbox", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATCrimsonHammersmith"] = { "Crimson Hammersmith (Summon)", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATBSPlansSerenity"] = { "Plans: Serenity", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATCannonMasterWilley"] = { "Cannon Master Willey", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATArchivistGalford"] = { "Archivist Galford", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATBalnazzar"] = { "Balnazzar", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATSothosJarien"] = { "Sothos and Jarien", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATStonespine"] = { "Stonespine", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATNerubenkan"] = { "Nerub'enkan", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATBaronessAnastari"] = { "Baroness Anastari", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATBlackGuardSwordsmith"] = { "Black Guard Swordsmith (Summon)", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATBSPlansCorruption"] = { "Plans: Corruption", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATMalekithePallid"] = { "Maleki the Pallid", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATMagistrateBarthilas"] = { "Magistrate Barthilas", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATRamsteintheGorger"] = { "Ramstein the Gorger", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATBaronRivendare"] = { "Baron Rivendare", "AtlasLootItems" };
    AtlasLoot_TableNames["STRATTrash"] = { "Trash Mobs (STRAT)", "AtlasLootItems" };
  --Sunken Temple
    AtlasLoot_TableNames["STSpawnOfHakkar"] = { "Spawn of Hakkar", "AtlasLootItems" };
    AtlasLoot_TableNames["STTrollMinibosses"] = { "Troll Minibosses", "AtlasLootItems" };
    AtlasLoot_TableNames["STAtalalarion"] = { "Atal'alarion", "AtlasLootItems" };
    AtlasLoot_TableNames["STDreamscythe"] = { "Dreamscythe", "AtlasLootItems" };
    AtlasLoot_TableNames["STWeaver"] = { "Weaver", "AtlasLootItems" };

    AtlasLoot_TableNames["STAvatarofHakkar"] = { "Avatar of Hakkar", "AtlasLootItems" };
    AtlasLoot_TableNames["STJammalan"] = { "Jammal'an the Prophet", "AtlasLootItems" };
    AtlasLoot_TableNames["STOgom"] = { "Ogom the Wretched", "AtlasLootItems" };
    AtlasLoot_TableNames["STMorphaz"] = { "Morphaz", "AtlasLootItems" };
    AtlasLoot_TableNames["STHazzas"] = { "Hazzas", "AtlasLootItems" };
    AtlasLoot_TableNames["STEranikus"] = { "Shade of Eranikus", "AtlasLootItems" };
    AtlasLoot_TableNames["STTrash"] = { "Trash Mobs (ST)", "AtlasLootItems" };
  --Temple of Ahn'Qiraj
    AtlasLoot_TableNames["AQ40Skeram"] = { "The Prophet Skeram", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Vem"] = { "The Bug Family", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Sartura"] = { "Battleguard Sartura", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Fankriss"] = { "Fankriss the Unyielding", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Viscidus"] = { "Viscidus", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Huhuran"] = { "Princess Huhuran", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Emperors"] = { "The Twin Emperors", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Ouro"] = { "Ouro", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40CThun"] = { "C'Thun", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Trash1"] = { "Trash Mobs (AQ40)", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Trash2"] = { "Trash Mobs (AQ40)", "AtlasLootItems" };
    AtlasLoot_TableNames["AQOpening"] = { "AQ Opening Quest Line", "AtlasLootItems" };
  --TK: The Arcatraz
    AtlasLoot_TableNames["TKArcUnbound"] = { "Zereketh the Unbound", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcUnboundHEROIC"] = { "Zereketh the Unbound (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcThirdFragmentGuardian"] = { "Third Fragment Guardian", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcDalliah"] = { "Dalliah the Doomsayer", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcDalliahHEROIC"] = { "Dalliah the Doomsayer (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcScryer"] = { "Wrath-Scryer Soccothrates", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcScryerHEROIC"] = { "Wrath-Scryer Soccothrates (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcHarbinger"] = { "Harbinger Skyriss", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcHarbingerHEROIC"] = { "Harbinger Skyriss (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKArcTrash"] = { "Trash Mobs (TK: The Arcatraz)", "AtlasLootExpansionItems" };
  --TK: The Botanica
    AtlasLoot_TableNames["TKBotSarannis"] = { "Commander Sarannis", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotSarannisHEROIC"] = { "Commander Sarannis (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotFreywinn"] = { "High Botanist Freywinn", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotFreywinnHEROIC"] = { "High Botanist Freywinn (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotThorngrin"] = { "Thorngrin the Tender", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotThorngrinHEROIC"] = { "Thorngrin the Tender (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotLaj"] = { "Laj", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotLajHEROIC"] = { "Laj (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotSplinter"] = { "Warp Splinter", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotSplinterHEROIC"] = { "Warp Splinter (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKBotTrash"] = { "Trash Mobs (TK: The Botanica)", "AtlasLootExpansionItems" };
  --TK: The Eye
    AtlasLoot_TableNames["TKEyeAlar"] = { "Al'ar", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKEyeVoidReaver"] = { "Void Reaver", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKEyeSolarian"] = { "High Astromancer Solarian", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKEyeKaelthas"] = { "Kael'thas Sunstrider", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKEyeLegendaries"] = { "Legendary Items for Kael'thas Fight", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKEyeTrash"] = { "Trash Mobs (TK: The Eye)", "AtlasLootExpansionItems" };
  --TK: The Mechanar
    AtlasLoot_TableNames["TKMechGyro"] = { "Gatewatcher Gyro-Kill", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechGyroHEROIC"] = { "Gatewatcher Gyro-Kill (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechIron"] = { "Gatewatcher Iron-Hand", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechIronHEROIC"] = { "Gatewatcher Iron-Hand (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechCacheoftheLegion"] = { "Cache of the Legion", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechCapacitus"] = { "Mechano-Lord Capacitus", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechCapacitusHEROIC"] = { "Mechano-Lord Capacitus (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechSepethrea"] = { "Nethermancer Sepethrea", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechSepethreaHEROIC"] = { "Nethermancer Sepethrea (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechCalc"] = { "Pathaleon the Calculator", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechCalcHEROIC"] = { "Pathaleon the Calculator (Heroic)", "AtlasLootExpansionItems" };
    AtlasLoot_TableNames["TKMechTrash"] = { "Trash Mobs (TK: The Mechanar)", "AtlasLootExpansionItems" };
  --Uldaman
    AtlasLoot_TableNames["UldMagreganDeepshadow"] = { "Magregan Deepshadow", "AtlasLootItems" };
    AtlasLoot_TableNames["UldTabletofRyuneh"] = { "Tablet of Ryun'eh", "AtlasLootItems" };
    AtlasLoot_TableNames["UldKromStoutarmChest"] = { "Krom Stoutarm's Chest", "AtlasLootItems" };
    AtlasLoot_TableNames["UldGarrettFamilyChest"] = { "Garrett Family Chest", "AtlasLootItems" };
    AtlasLoot_TableNames["UldShovelphlange"] = { "Digmaster Shovelphlange", "AtlasLootItems" };
    AtlasLoot_TableNames["UldRevelosh"] = { "Revelosh", "AtlasLootItems" };
    AtlasLoot_TableNames["UldBaelog"] = { "Baelog", "AtlasLootItems" };
    AtlasLoot_TableNames["UldIronaya"] = { "Ironaya", "AtlasLootItems" };
    AtlasLoot_TableNames["UldObsidianSentinel"] = { "Obsidian Sentinel", "AtlasLootItems" };
    AtlasLoot_TableNames["UldAncientStoneKeeper"] = { "Ancient Stone Keeper", "AtlasLootItems" };
    AtlasLoot_TableNames["UldGalgannFirehammer"] = { "Galgann Firehammer", "AtlasLootItems" };
    AtlasLoot_TableNames["UldTabletofWill"] = { "Tablet of Will", "AtlasLootItems" };
    AtlasLoot_TableNames["UldShadowforgeCache"] = { "Shadowforge Cache", "AtlasLootItems" };
    AtlasLoot_TableNames["UldGrimlok"] = { "Grimlok", "AtlasLootItems" };
    AtlasLoot_TableNames["UldArchaedas"] = { "Archaedas", "AtlasLootItems" };
    AtlasLoot_TableNames["UldTrash"] = { "Trash Mobs (Uld)", "AtlasLootItems" };
  --Wailing Caverns
    AtlasLoot_TableNames["WCLordCobrahn"] = { "Lord Cobrahn", "AtlasLootItems" };
    AtlasLoot_TableNames["WCLadyAnacondra"] = { "Lady Anacondra", "AtlasLootItems" };
    AtlasLoot_TableNames["WCKresh"] = { "Kresh", "AtlasLootItems" };
    AtlasLoot_TableNames["WCLordPythas"] = { "Lord Pythas", "AtlasLootItems" };
    AtlasLoot_TableNames["WCSkum"] = { "Skum", "AtlasLootItems" };
    AtlasLoot_TableNames["WCLordSerpentis"] = { "Lord Serpentis", "AtlasLootItems" };
    AtlasLoot_TableNames["WCVerdan"] = { "Verdan the Everliving", "AtlasLootItems" };
    AtlasLoot_TableNames["WCMutanus"] = { "Mutanus the Devourer", "AtlasLootItems" };
    AtlasLoot_TableNames["WCDeviateFaerieDragon"] = { "Deviate Faerie Dragon", "AtlasLootItems" };
  --Zul'Aman
    AtlasLoot_TableNames["ZANalorakk"] = { "Nalorakk", "AtlasLootItems" };
    AtlasLoot_TableNames["ZAJanAlai"] = { "Jan'Alai", "AtlasLootItems" };
    AtlasLoot_TableNames["ZAAkilZon"] = { "Akil'Zon", "AtlasLootItems" };
    AtlasLoot_TableNames["ZAHalazzi"] = { "Halazzi", "AtlasLootItems" };
    AtlasLoot_TableNames["ZAJinZakk"] = { "Hexxlord Jin'Zakk", "AtlasLootItems" };
    AtlasLoot_TableNames["ZAZuljin"] = { "Zul'jin", "AtlasLootItems" };
  --Zul'Farrak
    AtlasLoot_TableNames["ZFAntusul"] = { "Antu'sul", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFThekatheMartyr"] = { "Theka the Martyr", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFWitchDoctorZumrah"] = { "Witch Doctor Zum'rah", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFNekrumGutchewer"] = { "Nekrum Gutchewer", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFSezzziz"] = { "Shadowpriest Sezz'ziz", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFDustwraith"] = { "Dustwraith", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFSergeantBly"] = { "Sergeant Bly", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFSandfury"] = { "Sandfury Executioner", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFHydromancerVelratha"] = { "Hydromancer Velratha", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFGahzrilla"] = { "Gahz'rilla", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFChiefUkorzSandscalp"] = { "Chief Ukorz Sandscalp", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFZerillis"] = { "Zerillis", "AtlasLootItems" };
    AtlasLoot_TableNames["ZFTrash"] = { "Trash Mobs (ZF)", "AtlasLootItems" };
  --Zul'Gurub
    AtlasLoot_TableNames["ZGJeklik"] = { "High Priestess Jeklik", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGVenoxis"] = { "High Priest Venoxis", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGMarli"] = { "High Priestess Mar'li", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGMandokir"] = { "Bloodlord Mandokir", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGGrilek"] = { "Gri'lek of the Iron Blood", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGHazzarah"] = { "Hazzarah the Dreamweaver", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGRenataki"] = { "Renataki of the Thousand Blades", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGWushoolay"] = { "Wushoolay the Storm Witch", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGGahzranka"] = { "Gahz'ranka", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGThekal"] = { "High Priest Thekal", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGArlokk"] = { "High Priestess Arlokk", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGJindo"] = { "Jin'do the Hexxer", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGHakkar"] = { "Hakkar", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGMuddyChurningWaters"] = { "Muddy Churning Waters", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGShared"] = { "Shared ZG Priest Drops", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGTrash1"] = { "Trash Mobs (ZG)", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGTrash2"] = { "Trash Mobs (ZG)", "AtlasLootItems" };
    AtlasLoot_TableNames["ZGEnchants"] = { "ZG Enchants", "AtlasLootItems" };
  --Arena PvP Sets, Season 1
    AtlasLoot_TableNames["ArenaDruid"] = { "Druid Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaHunter"] = { "Hunter Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaMage"] = { "Mage Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaPaladin"] = { "Paladin Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaPriest"] = { "Priest Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaRogue"] = { "Rogue Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaShaman"] = { "Shaman Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaWarlock"] = { "Warlock Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArenaWarrior"] = { "Warrior Arena Sets", "AtlasLootSetItems" };

------------
--- Sets ---
------------

  --Arena PvP Sets, Season 2
    AtlasLoot_TableNames["Arena2Druid"] = { "Druid Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Hunter"] = { "Hunter Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Mage"] = { "Mage Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Paladin"] = { "Paladin Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Priest"] = { "Priest Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Rogue"] = { "Rogue Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Shaman"] = { "Shaman Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Warlock"] = { "Warlock Arena Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Arena2Warrior"] = { "Warrior Arena Sets", "AtlasLootSetItems" };
  --Level 60 PvP Sets
    AtlasLoot_TableNames["PVPDruid"] = { "Druid PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPHunter"] = { "Hunter PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPMage"] = { "Mage PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPPaladin"] = { "Paladin PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPPriest"] = { "Priest PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPRogue"] = { "Rogue PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPShaman"] = { "Shaman PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPWarlock"] = { "Warlock PvP Sets (Lvl 60)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVPWarrior"] = { "Warrior PvP Sets (Lvl 60)", "AtlasLootSetItems" };
  --Level 70 PvP Sets
    AtlasLoot_TableNames["PVP70Druid1"] = { "Druid PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Druid2"] = { "Druid PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Hunter"] = { "Hunter PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Mage"] = { "Mage PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Paladin1"] = { "Paladin PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Paladin2"] = { "Paladin PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Priest"] = { "Priest PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Rogue"] = { "Rogue PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Shaman1"] = { "Shaman PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Shaman2"] = { "Shaman PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Warlock"] = { "Warlock PvP Sets (Lvl 70)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PVP70Warrior"] = { "Warrior PvP Sets (Lvl 70)", "AtlasLootSetItems" };
  --Pre60 Sets
    AtlasLoot_TableNames["DEADMINES"] = { "Defias Leather", "AtlasLootSetItems" };
    AtlasLoot_TableNames["WAILING"] = { "Embrace of the Viper", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SCARLET"] = { "Chain of the Scarlet Crusade", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BLACKROCKD"] = { "The Gladiator", "AtlasLootSetItems" };
    AtlasLoot_TableNames["IRONWEAVE"] = { "Ironweave Battlesuit", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ScholoCloth"] = { "Necropile Raiment", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ScholoLeather"] = { "Cadaverous Garb", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ScholoMail"] = { "Bloodmail Regalia", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ScholoPlate"] = { "Deathbone Guardian", "AtlasLootSetItems" };
    AtlasLoot_TableNames["STRAT"] = { "The Postmaster", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ScourgeInvasion"] = { "Scourge Invasion", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ShardOfGods"] = { "Shard of the Gods", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGRings"] = { "Zul'Gurub Rings", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SpiritofEskhandar"] = { "Spirit of Eskhandar", "AtlasLootSetItems" };
    AtlasLoot_TableNames["HakkariBlades"] = { "The Twin Blades of Hakkari", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PrimalBlessing"] = { "Primal Blessing", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DalRend"] = { "Dal'Rend's Arms", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SpiderKiss"] = { "Spider's Kiss", "AtlasLootSetItems" };
  --BC Sets
    AtlasLoot_TableNames["TwinStars"] = { "The Twin Stars", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AzzinothBlades"] = { "The Twin Blades of Azzinoth", "AtlasLootSetItems" };
  --Crafted Sets - Blacksmithing
    AtlasLoot_TableNames["ImperialPlate"] = { "Imperial Plate", "AtlasLootSetItems" };
    AtlasLoot_TableNames["TheDarksoul"] = { "The Darksoul", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FelIronPlate"] = { "Fel Iron Plate", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AdamantiteB"] = { "Adamantite Battlegear", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FlameG"] = { "Flame Guard", "AtlasLootSetItems" };
    AtlasLoot_TableNames["EnchantedAdaman"] = { "Enchanted Adamantite Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["KhoriumWard"] = { "Khorium Ward", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FaithFelsteel"] = { "Faith in Felsteel", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BurningRage"] = { "Burning Rage", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BloodsoulEmbrace"] = { "Bloodsoul Embrace", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FelIronChain"] = { "Fel Iron Chain", "AtlasLootSetItems" };
  --Crafted Sets - Tailoring
    AtlasLoot_TableNames["BloodvineG"] = { "Bloodvine Garb", "AtlasLootSetItems" };
    AtlasLoot_TableNames["NeatherVest"] = { "Netherweave Vestments", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ImbuedNeather"] = { "Imbued Netherweave", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ArcanoVest"] = { "Arcanoweave Vestments", "AtlasLootSetItems" };
    AtlasLoot_TableNames["TheUnyielding"] = { "The Unyielding", "AtlasLootSetItems" };
    AtlasLoot_TableNames["WhitemendWis"] = { "Whitemend Wisdom", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SpellstrikeInfu"] = { "Spellstrike Infusion", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BattlecastG"] = { "Battlecast Garb", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SoulclothEm"] = { "Soulcloth Embrace", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PrimalMoon"] = { "Primal Mooncloth", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ShadowEmbrace"] = { "Shadow's Embrace", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SpellfireWrath"] = { "Wrath of Spellfire", "AtlasLootSetItems" };
  --Crafted Sets - Leatherworking
    AtlasLoot_TableNames["VolcanicArmor"] = { "Volcanic Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["IronfeatherArmor"] = { "Ironfeather Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["StormshroudArmor"] = { "Stormshroud Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DevilsaurArmor"] = { "Devilsaur Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BloodTigerH"] = { "Blood Tiger Harness", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PrimalBatskin"] = { "Primal Batskin", "AtlasLootSetItems" };
    AtlasLoot_TableNames["WildDraenishA"] = { "Wild Draenish Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ThickDraenicA"] = { "Thick Draenic Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FelSkin"] = { "Fel Skin", "AtlasLootSetItems" };
    AtlasLoot_TableNames["SClefthoof"] = { "Strength of the Clefthoof", "AtlasLootSetItems" };
    AtlasLoot_TableNames["GreenDragonM"] = { "Green Dragon Mail", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BlueDragonM"] = { "Blue Dragon Mail", "AtlasLootSetItems" };
    AtlasLoot_TableNames["BlackDragonM"] = { "Black Dragon Mail", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ScaledDraenicA"] = { "Scaled Draenic Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FelscaleArmor"] = { "Felscale Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["FelstalkerArmor"] = { "Felstalker Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["NetherFury"] = { "Fury of the Nether", "AtlasLootSetItems" };
    AtlasLoot_TableNames["PrimalIntent"] = { "Primal Intent", "AtlasLootSetItems" };
    AtlasLoot_TableNames["WindhawkArmor"] = { "Windhawk Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["NetherscaleArmor"] = { "Netherscale Armor", "AtlasLootSetItems" };
    AtlasLoot_TableNames["NetherstrikeArmor"] = { "Netherstrike Armor", "AtlasLootSetItems" };
  --ZG Sets
    AtlasLoot_TableNames["ZGDruid"] = { "Druid ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGHunter"] = { "Hunter ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGMage"] = { "Mage ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGPaladin"] = { "Paladin ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGPriest"] = { "Priest ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGRogue"] = { "Rogue ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGShaman"] = { "Shaman ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGWarlock"] = { "Warlock ZG Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["ZGWarrior"] = { "Warrior ZG Set", "AtlasLootSetItems" };
  --AQ20 Sets
    AtlasLoot_TableNames["AQ20Druid"] = { "Druid AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Hunter"] = { "Hunter AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Mage"] = { "Mage AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Paladin"] = { "Paladin AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Priest"] = { "Priest AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Rogue"] = { "Rogue AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Shaman"] = { "Shaman AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Warlock"] = { "Warlock AQ20 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ20Warrior"] = { "Warrior AQ20 Set", "AtlasLootSetItems" };
  --AQ40 Sets
    AtlasLoot_TableNames["AQ40Druid"] = { "Druid AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Emperors"] = { "The Twin Emperors", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Fankriss"] = { "Fankriss the Unyielding", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Huhuran"] = { "Princess Huhuran", "AtlasLootItems" };
    AtlasLoot_TableNames["AQ40Hunter"] = { "Hunter AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Mage"] = { "Mage AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Paladin"] = { "Paladin AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Priest"] = { "Priest AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Rogue"] = { "Rogue AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Shaman"] = { "Shaman AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Warlock"] = { "Warlock AQ40 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["AQ40Warrior"] = { "Warrior AQ40 Set", "AtlasLootSetItems" };
  --Dungeon Set 1/2
    AtlasLoot_TableNames["T0Druid"] = { "Druid Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Hunter"] = { "Hunter Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Mage"] = { "Mage Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Paladin"] = { "Paladin Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Priest"] = { "Priest Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Rogue"] = { "Rogue Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Shaman"] = { "Shaman Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Warlock"] = { "Warlock Dungeon Set 1/2", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T0Warrior"] = { "Warrior Dungeon Set 1/2", "AtlasLootSetItems" };
  --Dungeon Set 3
    AtlasLoot_TableNames["DS3Hallowed"] = { "Hallowed Raiment (Cloth)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Incanter"] = { "Incanter's Regalia (Cloth)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Mana"] = { "Mana-Etched Regalia (Cloth)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Oblivion"] = { "Oblivion Raiment (Cloth)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Assassin"] = { "Assassination Armor (Leather)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Moonglade"] = { "Moonglade Raiment (Leather)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Wastewalker"] = { "Wastewalker Armor (Leather)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Beast"] = { "Beast Lord Armor (Mail)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Desolation"] = { "Desolation Battlegear (Mail)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Tidefury"] = { "Tidefury Raiment (Mail)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Bold"] = { "Bold Armor (Plate)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Doom"] = { "Doomplate Battlegear (Plate)", "AtlasLootSetItems" };
    AtlasLoot_TableNames["DS3Right"] = { "Righteous Armor (Plate)", "AtlasLootSetItems" };
  --T1 Sets
    AtlasLoot_TableNames["T1Druid"] = { "Druid T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Hunter"] = { "Hunter T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Mage"] = { "Mage T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Paladin"] = { "Paladin T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Priest"] = { "Priest T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Rogue"] = { "Rogue T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Shaman"] = { "Shaman T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Warlock"] = { "Warlock T1 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T1Warrior"] = { "Warrior T1 Set", "AtlasLootSetItems" };
  --T2 Sets
    AtlasLoot_TableNames["T2Druid"] = { "Druid T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Hunter"] = { "Hunter T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Mage"] = { "Mage T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Paladin"] = { "Paladin T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Priest"] = { "Priest T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Rogue"] = { "Rogue T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Shaman"] = { "Shaman T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Warlock"] = { "Warlock T2 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T2Warrior"] = { "Warrior T2 Set", "AtlasLootSetItems" };
  --T3 Sets
    AtlasLoot_TableNames["T3Druid"] = { "Druid T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Hunter"] = { "Hunter T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Mage"] = { "Mage T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Paladin"] = { "Paladin T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Priest"] = { "Priest T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Rogue"] = { "Rogue T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Shaman"] = { "Shaman T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Warlock"] = { "Warlock T3 Set", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T3Warrior"] = { "Warrior T3 Set", "AtlasLootSetItems" };
  --T4 Sets
    AtlasLoot_TableNames["T4Druid"] = { "Druid T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Hunter"] = { "Hunter T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Mage"] = { "Mage T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Paladin"] = { "Paladin T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Priest"] = { "Priest T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Rogue"] = { "Rogue T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Shaman"] = { "Shaman T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Warlock"] = { "Warlock T4 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T4Warrior"] = { "Warrior T4 Sets", "AtlasLootSetItems" };
  --T5 Sets
    AtlasLoot_TableNames["T5Druid"] = { "Druid T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Hunter"] = { "Hunter T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Mage"] = { "Mage T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Paladin"] = { "Paladin T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Priest"] = { "Priest T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Rogue"] = { "Rogue T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Shaman"] = { "Shaman T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Warlock"] = { "Warlock T5 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T5Warrior"] = { "Warrior T5 Sets", "AtlasLootSetItems" };
  --T6 Sets
    AtlasLoot_TableNames["T6Druid"] = { "Druid T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Hunter"] = { "Hunter T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Mage"] = { "Mage T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Paladin"] = { "Paladin T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Priest"] = { "Priest T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Rogue"] = { "Rogue T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Shaman"] = { "Shaman T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Warlock"] = { "Warlock T6 Sets", "AtlasLootSetItems" };
    AtlasLoot_TableNames["T6Warrior"] = { "Warrior T6 Sets", "AtlasLootSetItems" };
  --Misc Sets
    AtlasLoot_TableNames["CraftedWeapons1"] = { "Crafted Epic Weapons", "AtlasLootSetItems" };
    AtlasLoot_TableNames["CraftedWeapons2"] = { "Crafted Epic Weapons", "AtlasLootSetItems" };
    AtlasLoot_TableNames["HardModeToken"] = { "Lvl70 Instance Rewards: Accessories", "AtlasLootSetItems" };
    AtlasLoot_TableNames["HardModeToken2"] = { "Lvl70 Instance Rewards: Fire Resistance Gear", "AtlasLootSetItems" };
    AtlasLoot_TableNames["HardModeToken3"] = { "Lvl70 Instance Rewards: Armor and Weapons", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Legendaries"] = { "Legendary Items", "AtlasLootSetItems" };
    AtlasLoot_TableNames["RareMounts"] = { "Rare Mounts", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Tabards1"] = { "Tabards", "AtlasLootSetItems" };
    AtlasLoot_TableNames["Tabards2"] = { "Tabards", "AtlasLootSetItems" };
    AtlasLoot_TableNames["CardGame1"] = { "Upper Deck Card Game Items", "AtlasLootSetItems" };

--------------------
--- World Bosses ---
--------------------

  --Azuregos
    AtlasLoot_TableNames["AAzuregos"] = { "Azuregos", "AtlasLootWBItems" };
  --Doom Lord Kazzak
    AtlasLoot_TableNames["DoomLordKazzak"] = { "Doom Lord Kazzak", "AtlasLootWBItems" };
  --Doomwalker
    AtlasLoot_TableNames["DDoomwalker"] = { "Doomwalker", "AtlasLootWBItems" };
  --Emrald Dragons
    AtlasLoot_TableNames["DEmeriss"] = { "Emeriss", "AtlasLootWBItems" };
    AtlasLoot_TableNames["DLethon"] = { "Lethon", "AtlasLootWBItems" };
    AtlasLoot_TableNames["DTaerar"] = { "Taerar", "AtlasLootWBItems" };
    AtlasLoot_TableNames["DYsondre"] = { "Ysondre", "AtlasLootWBItems" };
  --Highlord Kruul
    AtlasLoot_TableNames["KKruul"] = { "Highlord Kruul", "AtlasLootWBItems" };

--------------
--- Events ---
--------------

    AtlasLoot_TableNames["BashirLanding"] = { "Bash'ir Landing Skygaurd Raid", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["ChildrensWeek"] = { "Children's Week", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["ElementalInvasion"] = { "Elemental Invasion", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["FishingExtravaganza"] = { "Stranglethorn Fishing Extravaganza", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["GurubashiArena"] = { "Gurubashi Arena Booty Run", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["DarkscreecherAkkarai"] = { "Darkscreecher Akkarai", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["Karrog"] = { "Karrog", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["GezzaraktheHuntress"] = { "Gezzarak the Huntress", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["VakkiztheWindrager"] = { "Vakkiz the Windrager", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["Terokk"] = { "Terokk", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["ArmbreakerHuffaz"] = { "Armbreaker Huffaz", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["FelTinkererZortan"] = { "Fel Tinkerer Zortan", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["Forgosh"] = { "Forgosh <The Duke of Fiends>", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["Gulbor"] = { "Gul'bor <The Den Mother>", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["MalevustheMad"] = { "Malevus the Mad", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["PorfustheGemGorger"] = { "Porfus the Gem Gorger", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["WrathbringerLaztarash"] = { "Wrathbringer Laz-tarash", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["BashirStasisChambers"] = { "Bash'ir Landing Stasis Chambers", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["Templars"] = { "Abyssal Council - Templars", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["Dukes"] = { "Abyssal Council - Dukes", "AtlasLootWorldEvents" };
    AtlasLoot_TableNames["HighCouncil"] = { "Abyssal Council - High Council", "AtlasLootWorldEvents" };

--------------------
--- Rep Factions ---
--------------------

  --Aldor
    AtlasLoot_TableNames["Aldor1"] = { "The Aldor: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Aldor2"] = { "The Aldor: Revered/Exalted", "AtlasLootRepItems" };
  --The Argent Dawn
    AtlasLoot_TableNames["Argent1"] = { "Argent Dawn: Token Hand-ins", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Argent2"] = { "Argent Dawn", "AtlasLootRepItems" };
  --Ashtongue Deathsworn
    AtlasLoot_TableNames["Ashtongue1"] = { "Ashtongue Deathsworn", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Ashtongue2"] = { "Ashtongue Deathsworn", "AtlasLootRepItems" };
  --The Bloodsail Buccaneers
    AtlasLoot_TableNames["Bloodsail1"] = { "Bloodsail Buccaneers", "AtlasLootRepItems" };
  --The Brood of Nozdormu
    AtlasLoot_TableNames["AQBroodRings"] = { "Brood of Nozdormu", "AtlasLootRepItems" };
  --The Cenarion Circle
    AtlasLoot_TableNames["Cenarion1"] = { "Cenarion Circle: Friendly", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Cenarion2"] = { "Cenarion Circle: Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Cenarion3"] = { "Cenarion Circle: Revered", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Cenarion4"] = { "Cenarion Circle: Exalted", "AtlasLootRepItems" };
  --The Cenarion Expedition
    AtlasLoot_TableNames["CExpedition1"] = { "Cenarion Expedition: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["CExpedition2"] = { "Cenarion Expedition: Revered/Exalted", "AtlasLootRepItems" };
  --The Consortium
    AtlasLoot_TableNames["Consortium1"] = { "The Consortium: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Consortium2"] = { "The Consortium: Revered/Exalted", "AtlasLootRepItems" };
  --The Darkmoon Faire
    AtlasLoot_TableNames["Darkmoon1"] = { "Darkmoon Faire", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Darkmoon2"] = { "Darkmoon Faire - Trinkets", "AtlasLootRepItems" };
  --The Frostwolf Clan
    AtlasLoot_TableNames["Frostwolf1"] = { "Frostwolf Clan", "AtlasLootRepItems" };
  --The Hydraxian Waterlords
    AtlasLoot_TableNames["WaterLords1"] = { "Hydraxian Waterlords", "AtlasLootRepItems" };
  --Gelkis Clan Centaur
    AtlasLoot_TableNames["GelkisClan1"] = { "Gelkis Clan Centaur", "AtlasLootRepItems" };
  --Honor Hold
    AtlasLoot_TableNames["HonorHold1"] = { "Honor Hold: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["HonorHold2"] = { "Honor Hold: Revered/Exalted", "AtlasLootRepItems" };
  --The Keepers of Time
    AtlasLoot_TableNames["KeepersofTime1"] = { "Keepers of Time", "AtlasLootRepItems" };
  --The Kurenai
    AtlasLoot_TableNames["Kurenai1"] = { "Kurenai", "AtlasLootRepItems" };
  --Lower City
    AtlasLoot_TableNames["LowerCity1"] = { "Lower City", "AtlasLootRepItems" };
  --The Mag'har
    AtlasLoot_TableNames["Maghar1"] = { "The Mag'har", "AtlasLootRepItems" };
  --Magram Clan Centaur
    AtlasLoot_TableNames["MagramClan1"] = { "Magram Clan Centaur", "AtlasLootRepItems" };
  --Netherwing
    AtlasLoot_TableNames["Netherwing1"] = { "Netherwing", "AtlasLootRepItems" };
  --Ogri'la
    AtlasLoot_TableNames["Ogrila1"] = { "Ogri'la", "AtlasLootRepItems" };
  --The Scale of the Sands
    AtlasLoot_TableNames["ScaleSands1"] = { "The Scale of the Sands", "AtlasLootRepItems" };
    AtlasLoot_TableNames["ScaleSands2"] = { "The Scale of the Sands", "AtlasLootRepItems" };
  --The Scryers
    AtlasLoot_TableNames["Scryer1"] = { "The Scryers: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Scryer2"] = { "The Scryers: Revered/Exalted", "AtlasLootRepItems" };
  --The Sha'tar
    AtlasLoot_TableNames["Shatar1"] = { "The Sha'tar", "AtlasLootRepItems" };
  --Sha'tari Skyguard
    AtlasLoot_TableNames["Skyguard1"] = { "Sha'tari Skyguard", "AtlasLootRepItems" };
  --The Sporeggar
    AtlasLoot_TableNames["Sporeggar1"] = { "Sporeggar", "AtlasLootRepItems" };
  --The Stormpike Guard
    AtlasLoot_TableNames["Stormpike1"] = { "Stormpike Guard", "AtlasLootRepItems" };
  --The Thorium Brotherhood
    AtlasLoot_TableNames["Thorium1"] = { "Thorium Brotherhood: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Thorium2"] = { "Thorium Brotherhood: Revered/Exalted", "AtlasLootRepItems" };
  --Thrallmar
    AtlasLoot_TableNames["Thrallmar1"] = { "Thrallmar: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Thrallmar2"] = { "Thrallmar: Revered/Exalted", "AtlasLootRepItems" };
  --Timbermaw Hold
    AtlasLoot_TableNames["Timbermaw"] = { "Timbermaw Hold", "AtlasLootRepItems" };
  --The Tranquillien
    AtlasLoot_TableNames["Tranquillien1"] = { "Tranquillien", "AtlasLootRepItems" };
  --The Violet Eye
    AtlasLoot_TableNames["VioletEye1"] = { "The Violet Eye", "AtlasLootRepItems" };
  --The Wintersaber Trainers
    AtlasLoot_TableNames["Wintersaber1"] = { "Wintersaber Trainers", "AtlasLootRepItems" };
  --The Zandalar Tribe
    AtlasLoot_TableNames["Zandalar1"] = { "Zandalar Tribe: Friendly/Honored", "AtlasLootRepItems" };
    AtlasLoot_TableNames["Zandalar2"] = { "Zandalar Tribe: Revered/Exalted", "AtlasLootRepItems" };

-----------
--- PvP ---
-----------

  --Battlegrounds
    AtlasLoot_TableNames["ABMisc"] = { "Arathi Basin Misc. Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["ABBlue"] = { "Arathi Basin Blue Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["ABPurple"] = { "Arathi Basin Purple Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["ABSets1"] = { "Arathi Basin Armor Sets (Cloth/Leather)", "AtlasLootBGItems" };
    AtlasLoot_TableNames["ABSets2"] = { "Arathi Basin Armor Sets (Mail/Plate)", "AtlasLootBGItems" };
    AtlasLoot_TableNames["AVMisc"] = { "Alterac Valley Misc. Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["AVBlue"] = { "Alterac Valley Blue Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["AVPurple"] = { "Alterac Valley Purple Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["WSGMisc"] = { "Warsong Gulch Misc. Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["WSGBlue"] = { "Warsong Gulch Blue Rewards", "AtlasLootBGItems" };
    AtlasLoot_TableNames["WSGPurple"] = { "Warsong Gulch Purple Rewards", "AtlasLootBGItems" };
  --World PvP
    AtlasLoot_TableNames["Hellfire"] = { "Hellfire Peninsula: Fortifications", "AtlasLootWorldPvPItems" };
    AtlasLoot_TableNames["Nagrand1"] = { "Nagrand: Halaa", "AtlasLootWorldPvPItems" };
    AtlasLoot_TableNames["Nagrand2"] = { "Nagrand: Halaa", "AtlasLootWorldPvPItems" };
    AtlasLoot_TableNames["Terokkar"] = { "Terokkar Forest: Spirit Towers", "AtlasLootWorldPvPItems" };
    AtlasLoot_TableNames["Zangarmarsh"] = { "Zangarmarsh: The Twin Spires", "AtlasLootWorldPvPItems" };
  --Misc Other PvP
    AtlasLoot_TableNames["PvP60Accessories1"] = { "PvP Accessories (Level 60)", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP60Accessories2"] = { "PvP Accessories - Alliance (Level 60)", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP60Accessories3"] = { "PvP Accessories - Horde (Level 60)", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70Accessories1"] = { "PvP Accessories (Level 70)", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70Accessories2"] = { "PvP Accessories (Level 70)", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70NonSet1"] = { "PvP Non-Set Epics: Accessories", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70NonSet2"] = { "PvP Non-Set Epics: Cloth", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70NonSet3"] = { "PvP Non-Set Epics: Leather", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70NonSet4"] = { "PvP Non-Set Epics: Mail", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PvP70NonSet5"] = { "PvP Non-Set Epics: Plate", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PVPWeapons1"] = { "Level 60 PvP Weapons", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PVPWeapons2"] = { "Level 60 PvP Weapons", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PVP70Weapons1"] = { "Level 70 PvP Weapons", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["PVP70Weapons2"] = { "Level 70 PvP Weapons", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["ArenaWeapons"] = { "Arena Season 1 Weapons", "AtlasLootGeneralPvPItems" };
    AtlasLoot_TableNames["Arena2Weapons"] = { "Arena Season 2 Weapons", "AtlasLootGeneralPvPItems" };

-------------
--- Other ---
-------------

  --Menus, the entry does nothing, but makes the generalised loot table code less complex
    AtlasLoot_TableNames["AQ40SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["AQ20SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["ZGSET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["PRE60SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["CRAFTSET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["CRAFTSET2"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T6SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T5SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T4SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T3SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T2SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T1SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["T0SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["DS3SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["PVPSET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["PVP70SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["PVP70NONSETEPICS"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["ARENASET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["ARENA2SET"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["REPMENU_AZEROTHPREBC"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["REPMENU_AZEROTHPOSTBC"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["REPMENU_OUTLAND"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["REPMENU_SHATTRATH"] = { "dummy", "dummy" };
    AtlasLoot_TableNames["REPMENU"] = { "dummy", "dummy" };
  --If all else fails!
    AtlasLoot_TableNames["EmptyInstance"] = { "AtlasLoot", "AtlasLootFallback" };